@extends('layouts.master_panel')

@section('title') Documents  @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />


@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>




@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Documents  </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item active" aria-current="page">Documents  </li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12" id="documents" >
  <div class="card">
  <h5 class="card-header">Documents</h5>
  <div class="card-body">


      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th>Type</th>
              <th>Pour</th>
              <th>Nom du document</th>
              <th>Télécharger</th>
            </tr>
            </thead>
            <tbody>

@foreach($Depotdocuments as $Depotdoc)


                <tr>

                  

                  
@if($Depotdoc->type == 1 AND !empty($Depotdoc->class_id))
<td><span class="badge badge-info"><i class="fa fa-info-circle"></i> Classes</span></td>

<td>
  <?php $getClasse = \App\Classes::find($Depotdoc->class_id); ?>
  @if($getClasse !== null ) {{ $getClasse->name }} @endif
</td>
@elseif($Depotdoc->type == 1 AND empty($Depotdoc->class_id))
<td><span class="badge badge-info"><i class="fa fa-info-circle"></i> Elève</span></td>

<td>
  <?php $getUser = \App\User::find($Depotdoc->student_id); ?>
  @if($getUser !== null ) {{ $getUser->last_name . ' ' . $getUser->first_name }} @endif

</td>
@elseif($Depotdoc->type == 2)
<td><span class="badge badge-info"><i class="fa fa-info-circle"></i> Enseignants</span></td>
<td>
  <?php $geTeacher = \App\User::find($Depotdoc->teacher_id); ?>
  @if($geTeacher !== null ) {{ $geTeacher->last_name . ' ' . $geTeacher->first_name }} @endif
</td>
@endif

                  <td>
                    <?php echo html_entity_decode($Depotdoc->doc_name); ?>
                  </td>

                  <td>
                    <a class="btn btn-rounded btn-dark btn-sm" target="_black" href="{{ url('/') }}/uploads/emploi/{{ $Depotdoc->fichier }}"><i class="fas fa-download"></i></a>
                  </td>


                </tr>


@endforeach
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>




                                     


</div><!-- END row -->
                
               

@stop