@extends('layouts.master_panel')

@section('title') Demandes de rencontre avec les parents @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />


@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });
  </script>


<script src="{{url('/')}}/assets/vendor/datepicker/moment.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.js"></script>
<script src="{{url('/')}}/assets/vendor/datepicker/datepicker.js"></script>

<script src="{{url('/')}}/assets/vendor/datepicker/fr.js"></script>

<script type="text/javascript">
    $(function () {
        $('#datetimepickerdate').datetimepicker({
          format: 'DD/MM/YYYY',
          locale: 'fr'
      });
    });

    $(function () {
        $('#timepicker').datetimepicker({
          format: 'HH:mm',
          locale: 'fr'
      });
    });

</script>



<script type="text/javascript">
$(document).ready(function () { 

        $('#classID').on('change',function(e){
          
            var class_id = e.target.value;
 
            $.ajax({
            type: "GET",
            url: "{{ url('/') }}/enseignant/ajax_students_class?class_id="+class_id,
            success: function(data) {  

                var subcat =  $('#studentsID').empty();

                  $.each(data, function(key, val) {    
                    subcat.append('<option value ="'+val.id+'">'+val.last_name+' '+val.first_name+'</option>');
                  });

                  $('.selectpicker').selectpicker('refresh');

              }

            });


          });


});
</script>



@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Demandes de rencontre avec les parents</h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item active" aria-current="page">Demandes de rencontre avec les parents </li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif
</div>
<div class="clearfix"></div>




@if(auth()->user()->super_admin == 1 AND isset($_GET['id']))

<?php $getDemande = \App\DemandesRencontre::find(e($_GET['id'])); ?>

<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
  <div class="card-body">

<form method="POST" action="{{ URL::route('demandes_rencontre_update', $getDemande->id) }}" id="myForm" >

{{ csrf_field() }}

<div class="row">

<?php $DateTime = \DateTime::createFromFormat('Y-m-d', $getDemande->date); ?>

  <div class="col-md-6 mb-3">
    <label>Date proposée:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdate" data-target-input="nearest">

    <input name="date" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdate" required="required" value="{{ $DateTime->format('d/m/Y') }}" />
    
      <div class="input-group-append" data-target="#datetimepickerdate" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
  </div>

  <div class="col-md-6 mb-3">
    <label>Heure proposée:</label>
    <div class="form-group">
    <div class="input-group date" id="timepicker" data-target-input="nearest">

    <input name="heure" type="text" class="form-control datetimepicker-input" data-target="#timepicker" value="{{ $getDemande->heure }}" />
    
      <div class="input-group-append" data-target="#timepicker" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-clock"></i></div>
      </div>
    </div>
  </div>
  </div>

  <div class="col-md-12 mb-5 ">
      <label>Décision:</label>
      <select name="etat" class="selectpicker" data-width="100%" required="required">  
      @if($getDemande->etat == 0) 
        <option value="0" selected="selected">En cours</option>
        <option value="1">Confirmé</option>
        <option value="2">Annulé</option>
      @elseif($getDemande->etat == 1) 
        <option value="0">En cours</option>
        <option value="1" selected="selected">Confirmé</option>
        <option value="2">Annulé</option>
      @elseif($getDemande->etat == 2) 
        <option value="0">En cours</option>
        <option value="1">Confirmé</option>
        <option value="2" selected="selected">Annulé</option>
      @endif

      </select>
  </div>

 <div class="col-md-12 mb-3">
    <button class="btn btn-success btn-block text-uppercase" type="submit" id="submit" >Valider</button>
</div>

</div>

</form>
 </div>
  </div>
</div>

@endif

  


<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
@if(auth()->user()->is_teacher == 1)
    <h5 class="card-header">
      <a href="#" class="btn btn-primary mb-1" data-toggle="modal" data-target="#exampleModal"><i class="fa fa-plus"></i> Ajouter </a>
    </h5>
@endif
  <div class="card-body">


@if(auth()->user()->is_teacher == 1)
<!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel">Ajouter</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="{{ URL::route('demandes_rencontre_store') }}">

{{ csrf_field() }}


<div class="row">

  <div class="col-md-12 mb-3">
      <label>Classes:</label>
      <select name="class_id" id="classID" class="selectpicker" data-width="100%" required="required" title="Choisir">   
        @foreach($classes as $classe)
          <option value="{{ $classe->cl_id }}">{{ $classe->cl_name }} - {{ $classe->sbj_name }}</option>

        @endforeach
      </select>
  </div>

  <div class="col-md-12 mb-3">
      <label>Élèves:</label>
      <select name="student_ids[]" id="studentsID" class="selectpicker" data-width="100%" required="required" multiple="multiple" title="Choisir">   
      </select>
  </div>


  <div class="col-md-6 mb-3">
    <label>Date proposée:</label>
    <div class="form-group">
    <div class="input-group date" id="datetimepickerdate" data-target-input="nearest">

    <input name="date" type="text" class="form-control datetimepicker-input" data-target="#datetimepickerdate" required="required" value="{{ date('d/m/Y') }}" />
    
      <div class="input-group-append" data-target="#datetimepickerdate" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-calendar-alt"></i></div>
      </div>
    </div>
  </div>
  </div>

  <div class="col-md-6 mb-3">
    <label>Heure proposée:</label>
    <div class="form-group">
    <div class="input-group date" id="timepicker" data-target-input="nearest">

    <input name="heure" type="text" class="form-control datetimepicker-input" data-target="#timepicker" value="{{ old('heure') }}" />
    
      <div class="input-group-append" data-target="#timepicker" data-toggle="datetimepicker">
      <div class="input-group-text"><i class="far fa-clock"></i></div>
      </div>
    </div>
  </div>
  </div>

  <div class="col-md-12 mb-3">
    <div class="form-group">
    <label>Objet:</label>
    <div class="input-group">
    <div class="input-group-prepend"><span class="input-group-text"><i class="fas fa-pencil-alt"></i></span></div>
    <input name="objet" type="text" class="form-control" value="" required="required">
    </div>
    </div>
  </div>

  <div class="col-md-12 mb-3">
    <label>Description:</label>
    <textarea name="details" class="form-control" rows="7" required="required" >{{ old('details') }}</textarea>
  </div>

 
</div>

<div class="row mt-1">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Valider</button>
</div>
</div>

</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->
@endif

<div class="clearfix"></div>


      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th style="display: none;">#</th>
              <th>Élèves</th>
              <th>Classe</th>
              @if(auth()->user()->is_admin == 1)
              <th>Enseignant(e)</th>
              @endif
              <th>Date</th>
              <th>Objet</th>
              <th>Description</th>
              <th>état</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

@foreach($demandes_rencontre as $demand_rencontre)

<?php 
if(auth()->user()->is_teacher == 1) {

  if ($demand_rencontre->teacher_readed == 0 AND $demand_rencontre->etat !== 0) {
    $demand_rencontre->teacher_readed = 1;
    $demand_rencontre->save();
  }

}
?>
              <tr>

                  <td style="display: none;">{{ $demand_rencontre->id }}</td>

                  <td>
                    @foreach($demand_rencontre->students as $stnd)
                      <span class="badge badge-dark">
                      {{ $stnd->student->last_name . ' ' . $stnd->student->first_name }}
                      </span>
                      @endforeach
                  </td>
                                  
                  <td>
                    {{ $demand_rencontre->classe->name }}
                  </td>

                  @if(auth()->user()->is_admin == 1)
                  <td>
                    {{ $demand_rencontre->teacher->last_name . ' ' . $demand_rencontre->teacher->first_name }}
                  </td>
                  @endif

                  <td>
                    <?php $DateTime = \DateTime::createFromFormat('Y-m-d', $demand_rencontre->date); ?> {{ $DateTime->format('d/m/Y') }} à {{ $demand_rencontre->heure }}
                  </td>

                  <td>{{ $demand_rencontre->objet }}</td>
                  
                  <td>
                    
                    <a class="btn btn-primary btn-sm" href="#" data-toggle="modal" data-target="#exampleModal-{{ $demand_rencontre->id }}"><i class="fa fa-eye"></i> Description</a>

                
@if(!empty($demand_rencontre->rapport) AND auth()->user()->is_teacher == 1)

                    <a class="btn btn-primary btn-sm ml-1" href="#" data-toggle="modal" data-target="#rapport-{{ $demand_rencontre->id }}"><i class="fas fa-clipboard-list"></i> Rapport</a>

<!-- Modal -->
<div class="modal fade" id="rapport-{{ $demand_rencontre->id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalrapport-{{ $demand_rencontre->id }}" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalrapport-{{ $demand_rencontre->id }}">Le rapport</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">
    <?php echo strip_tags(html_entity_decode($demand_rencontre->rapport)); ?>
    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->
@endif


<!-- Modal -->
<div class="modal fade" id="exampleModal-{{ $demand_rencontre->id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel-{{ $demand_rencontre->id }}" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabel-{{ $demand_rencontre->id }}">Détails</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">
      
      <?php echo html_entity_decode($demand_rencontre->details); ?>
   
    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->


                  </td>

                  <td>
                    @if($demand_rencontre->etat == 0)
                      <span class="badge badge-warning text-white"><i class="fa fa-hourglass"></i> En cours</span> 
                    @elseif($demand_rencontre->etat == 1)
                      <span class="badge badge-success text-white"><i class="fa fa-check-circle"></i> Confirmé </span>
                    @elseif($demand_rencontre->etat == 2)
                      <span class="badge badge-danger text-white"><i class="fas fa-exclamation-triangle"></i> Annulé </span>
                    @endif
                  </td>


                  <td>

@if(auth()->user()->super_admin == 1)
                    
                    <a class="btn btn-success btn-sm ml-1 mb-1" href="{{ URL::current() . '?id=' . $demand_rencontre->id }}"><i class="far fa-edit"></i> décision</a>

                    <a class="btn btn-success btn-sm ml-1 mb-1" href="#" data-toggle="modal" data-target="#rapport-{{ $demand_rencontre->id }}"><i class="fas fa-clipboard-list"></i> rapport</a>

                    <a onclick="return confirm('Supprimer?')" href="{{ URL::route('demandes_rencontre_delete', $demand_rencontre->id) }}" class="btn btn-danger btn-sm ml-1 mb-1"><i class="fa fa-trash"></i></a>


<!-- Modal -->
<div class="modal fade" id="rapport-{{ $demand_rencontre->id }}" tabindex="-1" role="dialog" aria-labelledby="exampleModalrapport-{{ $demand_rencontre->id }}" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalrapport-{{ $demand_rencontre->id }}">Le rapport</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="{{ URL::route('demandes_rencontre_rapport', $demand_rencontre->id) }}" >

{{ csrf_field() }}

<div class="row">

<div class="col-md-12 mb-3">
    <label>Le rapport:</label>
    <textarea name="rapport" class="form-control" rows="7"><?php echo strip_tags(html_entity_decode($demand_rencontre->rapport)); ?></textarea>
 </div>

 <div class="col-md-12 mb-3">
    <button class="btn btn-success btn-block text-uppercase" type="submit">Valider</button>
</div>

</div>

</form>


      
   
    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->

@endif
                @if(auth()->user()->is_teacher == 1)
                    @if($demand_rencontre->etat == 0)
                    <a onclick="return confirm('Supprimer?')" href="{{ URL::route('demandes_rencontre_delete', $demand_rencontre->id) }}" class="btn btn-danger btn-sm ml-1 mb-1"><i class="fa fa-trash"></i>  </a>
                    @else - @endif
                @endif

                  </td>

              </tr>

@endforeach
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>

                                     


</div><!-- END row -->
                
               

@stop