@extends('layouts.master_panel')

@section('title') Emploi du temps & dépôt des documents @stop

@section('CSS') 


<link rel="stylesheet" type="text/css" href="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.css">

<link rel="stylesheet" href="{{url('/')}}/assets/vendor/datepicker/tempusdominus-bootstrap-4.css" />


@stop

@section('JS') 


<script src="{{url('/')}}/js/datatables/jquery.dataTables.min.js"></script>
<script src="{{url('/')}}/js/datatables/dataTables.bootstrap4.min.js"></script>

<script type="text/javascript" class="init">
  $(document).ready(function() {
    $("#example").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });

$(document).ready(function() {
    $("#example2").dataTable({ "language": { "url": "{{ url('/') }}/js/datatables/lang/fr.json" },
      "order": [[ 0, "desc" ]]
    });
  });

  </script>




<script type="text/javascript">
function ValidateSize(file) {
  var FileSize = file.files[0].size / 1024 / 1024; // in MB
  if (FileSize > 10) {
      $('#file').val(''); //for clearing with Jquery
      alert('La taille du fichier dépasse 10 Mo');
      
  } 
}
</script>




<script type="text/javascript">
$(document).ready(function () { 

        $('#ClassesOrEnseignants').on('change',function(et){
            
            var type = et.target.value;

            if (type == 1) {
              $("#tag-Classes").css('display','block');
              $("#tag-Enseignants").css('display','none');
            } else {
              $("#tag-Classes").css('display','none');
              $("#tag-Enseignants").css('display','block');
            }


        });


        $('#ClassesOrEnseignants2').on('change',function(etd){

            $("#tag-Students2").css('display','none');
            
            var typed = etd.target.value;

            if (typed == 1) {
              $("#tag-Classes2").css('display','block');
              $("#tag-Enseignants2").css('display','none');
            } else {
              $("#tag-Classes2").css('display','none');
              $("#tag-Enseignants2").css('display','block');
            }


        });

        

      $('#ClassID').on('change',function(e){

          var class_id = e.target.value;

          $("#tag-Students2").css('display','block');

//console.log(class_id);
if (class_id) {

          $.ajax({
            type: "GET",
            url: "{{ url('/') }}/enseignant/ajax_students_class?class_id="+class_id,
            success: function(data) {  

              var subcat =  $('#studentID').empty();

              subcat.append('<option selected="selected" value="">Tout sélectionner</option>');

              $.each(data, function(key, val) { 
                subcat.append('<option value ="'+val.id+'">'+val.last_name+' '+val.first_name+'</option>');
              });

              $('.selectpicker').selectpicker('refresh');

            }

          });

} else {
  var subcat =  $('#studentID').empty();
  subcat.append('<option selected="selected" value="">Tout sélectionner</option>');
}
      
    });


});
</script>


@stop


@section('content')


                  <!-- ============================================================== -->
                  <!-- pageheader  -->
                  <!-- ============================================================== -->
                  <div class="row">
                      <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                          <div class="page-header">
                              <h3 class="mb-2">Emploi du temps & dépôt des documents  </h3>
                           
                              <div class="page-breadcrumb">
                                  <nav aria-label="breadcrumb">
                                      <ol class="breadcrumb">
                                          <li class="breadcrumb-item active" aria-current="page">Emploi du temps & dépôt des documents  </li>
                                      </ol>
                                  </nav>
                              </div>
                          </div>
                      </div>
                  </div>
                  <!-- ============================================================== -->
                  <!-- end pageheader  -->
                  <!-- ============================================================== -->


<div class="row">

<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">

@if(auth()->user()->super_admin == 1)
  <a href="#" class="btn btn-primary mb-3" data-toggle="modal" data-target="#exampleModalEmploi"><i class="fa fa-plus"></i> Emploi du temps </a>

  <a href="#" class="btn btn-primary mb-3" data-toggle="modal" data-target="#exampleModalDocuments"><i class="fa fa-plus"></i> Dépôt des documents </a>

@endif
<div class="clearfix"></div>

@if(Session::has('error'))

<div class="alert alert-danger alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('error') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>

@endif

@if(Session::has('success'))
<div class="alert alert-success alert-dismissible fade show text-center" role="alert">
  <strong>{{ Session::get('success') }}</strong>
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif


</div>



<!-- Modal -->
<div class="modal fade" id="exampleModalEmploi" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabelEmploi" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabelEmploi">Emploi du temps</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="{{ URL::route('admin_emploi_store') }}" enctype="multipart/form-data">

{{ csrf_field() }}

<input type="hidden" name="doc_type" value="1">

<div class="form-row">



  <div class="col-md-12 mb-3">
      <label>Classes/Enseignants:</label>
      <select name="type" id="ClassesOrEnseignants" class="form-control" data-width="100%" title="Choisir" required="required">  
        <option value="">Choisir</option> 
        <option value="1">Classes</option>
        <option value="2">Enseignants</option>

      </select>
  </div>


  <div class="col-md-12 mb-3" id="tag-Classes" style="display: none;">
      <label>Classes:</label>
      <select name="class_id" class="selectpicker" data-width="100%" title="Choisir">   
        @foreach($classes as $classe)
          <option value="{{ $classe->id }}">{{ $classe->name }}</option>
        @endforeach
      </select>
  </div>


  <div class="col-md-12 mb-3" id="tag-Enseignants" style="display: none;">
      <label>Enseignants:</label>
      <select name="teacher_id[]" class="selectpicker" data-width="100%" title="Choisir" multiple="multiple"> 
        @foreach($enseignants as $enseignant)
          <option value="{{ $enseignant->id }}">{{ $enseignant->last_name . ' ' . $enseignant->first_name }}</option>
        @endforeach
      </select>
  </div>



<div class="col-md-12 mb-3 mt-3">
      <label>Document PDF:</label>
        <div class="custom-file">
          <input type="file" id="file" name="file_join" required="required" onchange="ValidateSize(this)">
        </div>
        @if($errors->first('file_join'))
          <small class="form-text text-danger">{{ $errors->first('file_join') }}</small>
        @endif
</div>


 
</div>

<div class="form-row mt-1">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Ajouter</button>
</div>
</div>

</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->





<!-- Modal -->
<div class="modal fade" id="exampleModalDocuments" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabelDocuments" aria-hidden="true">
<div class="modal-dialog modal-lg" role="document">
  <div class="modal-content">
    <div class="modal-header">
      <h5 class="modal-title" id="exampleModalLabelDocuments">Dépôt des documents</h5>
      <a href="#" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></a>
    </div>
    <div class="modal-body">

<form method="POST" action="{{ URL::route('admin_emploi_store') }}" enctype="multipart/form-data">

{{ csrf_field() }}

<input type="hidden" name="doc_type" value="2">

<div class="form-row">


  <div class="col-md-12 mb-3"> 
    <label>Nom du document:</label>
    <div class="form-group">
    <input name="doc_name" type="text" class="form-control" />
    </div>
  </div>


  <div class="col-md-12 mb-3">
      <label>Classes/Enseignants:</label>
      <select name="type" id="ClassesOrEnseignants2" class="form-control" data-width="100%" title="Choisir" required="required">   
        <option value="">Choisir</option>
        <option value="1">Classes</option>
        <option value="2">Enseignants</option>

      </select>
  </div>


  <div class="col-md-12 mb-3" id="tag-Classes2" style="display: none;">
      <label>Classes:</label>
      <select name="class_ids[]" id="ClassID" class="selectpicker" data-width="100%" title="Choisir" multiple="multiple">   
        <option value="all">Tout sélectionner</option>
        @foreach($classes as $classe)
          <option value="{{ $classe->id }}">{{ $classe->name }}</option>
        @endforeach
      </select>
  </div>


  <div class="col-md-12 mb-3" id="tag-Students2" style="display: none;">
      <label>Elèves:</label>
      <select name="student_id" id="studentID" class="form-control" data-width="100%">
      </select>
  </div>


  <div class="col-md-12 mb-3" id="tag-Enseignants2" style="display: none;">
      <label>Enseignants:</label>
      <select name="teacher_ids[]" class="selectpicker" data-width="100%" title="Choisir" multiple="multiple">  

        <option value="all">Tout sélectionner</option>
        @foreach($enseignants as $enseignant)
          <option value="{{ $enseignant->id }}">{{ $enseignant->last_name . ' ' . $enseignant->first_name }}</option>
        @endforeach
      </select>
  </div>


<div class="col-md-12 mb-3 mt-3">
      <label>Document PDF:</label>
        <div class="custom-file">
          <input type="file" id="file" name="file_join" required="required" onchange="ValidateSize(this)">
        </div>
        @if($errors->first('file_join'))
          <small class="form-text text-danger">{{ $errors->first('file_join') }}</small>
        @endif
</div>


 
</div>

<div class="form-row mt-1">
<div class="col-md-12">
    <button class="btn btn-success btn-block" type="submit">Ajouter</button>
</div>
</div>

</form>

    </div>
    <div class="modal-footer">
      <a href="#" class="btn btn-dark" data-dismiss="modal">Fermer</a>
    </div>
  </div>
</div>
</div>
<!-- End Modal -->





<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
  <div class="card">
  <h5 class="card-header">Emploi du temps</h5>
  <div class="card-body">


      <div class="table-responsive">
          <table id="example" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th>Type</th>
              <th>Emploi Du</th>
              <th>Télécharger</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

@foreach($emploi as $empl)


                <tr>

                  
@if($empl->type == 1)
<td><span class="badge badge-info"><i class="fa fa-info-circle"></i> Classes</span></td>

<td>
  {{ $empl->classe->name }}
</td>
@else
<td><span class="badge badge-info"><i class="fa fa-info-circle"></i> Enseignants</span></td>
<td>
  {{ $empl->teacher->last_name . ' ' . $empl->teacher->first_name }}
</td>
@endif

                  <td>
                    <a class="btn btn-rounded btn-dark btn-sm" target="_black" href="{{ url('/') }}/uploads/emploi/{{ $empl->fichier }}"><i class="fas fa-download"></i></a>
                  </td>


                    <td>
 @if(auth()->user()->super_admin == 1)                     
                      <a onclick="return confirm('Supprimer?')" href="{{ URL::route('admin_emploi_delete', $empl->id) }}" class="btn btn-danger btn-sm mb-1"><i class="fa fa-trash"></i>  </a>
@endif
                    </td>

                </tr>


@endforeach
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>










<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12" id="documents" >
  <div class="card">
  <h5 class="card-header">Dépôt des documents</h5>
  <div class="card-body">


      <div class="table-responsive">
          <table id="example2" class="table table-striped table-bordered first">
            <thead>
            <tr class="text-uppercase">
              <th style="display: none;">#</th>
              <th>Type</th>
              <th>Pour</th>
              <th>Nom du document</th>
              <th>Télécharger</th>
              <th>Action</th>
            </tr>
            </thead>
            <tbody>

@foreach($Depotdocuments as $Depotdoc)


                <tr>

                  <td style="display: none;">{{ $Depotdoc->id }}</td>
                  
@if($Depotdoc->type == 1 AND !empty($Depotdoc->class_id))
<td><span class="badge badge-info"><i class="fa fa-info-circle"></i> Classes</span></td>

<td>
  <?php $getClasse = \App\Classes::find($Depotdoc->class_id); ?>
  @if($getClasse !== null ) {{ $getClasse->name }} @endif
</td>
@elseif($Depotdoc->type == 1 AND empty($Depotdoc->class_id))
<td><span class="badge badge-info"><i class="fa fa-info-circle"></i> Elève</span></td>

<td>
  <?php $getUser = \App\User::find($Depotdoc->student_id); ?>
  @if($getUser !== null ) {{ $getUser->last_name . ' ' . $getUser->first_name }} @endif

</td>
@elseif($Depotdoc->type == 2)
<td><span class="badge badge-info"><i class="fa fa-info-circle"></i> Enseignants</span></td>
<td>
  <?php $geTeacher = \App\User::find($Depotdoc->teacher_id); ?>
  @if($geTeacher !== null ) {{ $geTeacher->last_name . ' ' . $geTeacher->first_name }} @endif
</td>
@endif

                  <td>
                    <?php echo html_entity_decode($Depotdoc->doc_name); ?>
                  </td>

                  <td>
                    <a class="btn btn-rounded btn-dark btn-sm" target="_black" href="{{ url('/') }}/uploads/emploi/{{ $Depotdoc->fichier }}"><i class="fas fa-download"></i></a>
                  </td>


                    <td>
 @if(auth()->user()->super_admin == 1)                     
                      <a onclick="return confirm('Supprimer?')" href="{{ URL::route('admin_depot_document_delete', $Depotdoc->id) }}" class="btn btn-danger btn-sm mb-1"><i class="fa fa-trash"></i>  </a>
@endif
                    </td>

                </tr>


@endforeach
                  </tbody>
                  </table>
               </div>

    </div>
  </div>
</div>




                                     


</div><!-- END row -->
                
               

@stop