<!doctype html>
<html lang="fr">
 
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>Pointage</title>
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/bootstrap/css/bootstrap.min.css">
    <link href="{{url('/')}}/assets/vendor/fonts/circular-std/style.css" rel="stylesheet">
    <link rel="stylesheet" href="{{url('/')}}/assets/libs/css/style.css">
    <link rel="stylesheet" href="{{url('/')}}/assets/vendor/fonts/fontawesome/css/fontawesome-all.css">
    <style>
    html,
    body {
        height: 100%;
    }

    body {
        display: -ms-flexbox;
        display: flex;
        -ms-flex-align: center;
        align-items: center;
        padding-top: 10px;
        padding-bottom: 40px;
    }
    </style>

<script src="{{url('/')}}/assets/vendor/jquery/jquery-3.3.1.min.js"></script>

<script type="text/javascript">
document.onload = function() {  
  document.getElementById("barcode").focus();
}


$(document).on('shown.bs.modal', '.modal', function() {
  $(this).find('[autofocus]').focus();
});

</script>

</head>

<body>



    <div class="container">

        <div class="error-section-content text-center">

        <div style="text-align: center;">
            <a href="#"><img class="logo-img img-fluid" width="90px" src="{{url('/')}}/assets/images/logo2.png" alt="Groupe Scolaire Verdin"></a>
        </div>
        <div class="clearfix"></div><br>

        <h1 class="display-5 text-uppercase" style="color: #1C3DED;">Groupe Scolaire Verdin</h1>
        <h2 class="display-7 text-uppercase text-danger" style="line-height: 46px;">Passez votre carte devant le scanner</h2>

        <div class="clearfix"></div><br>

        

            

<form id="FormID" method="POST" action="{{ URL::route('pointage_scan') }}" class="row">

@csrf

    <div class="col-md-12">
          <div id="resultajax" class="text-center"></div>
    </div>


    <div class="col-md-6 offset-md-3">
        <div class="form-group">
        <div class="input-group">
        <div class="input-group-prepend"><span class="input-group-text"><i class="fa fa-barcode"></i></span></div>
        <input autocomplete="off" style="height: 45px; " type="password" name="barcode" onmouseover="this.focus();" class="form-control input-lg" id="barcode" required="required" autofocus>
        </div>
        </div>
    </div>
<?php /* ?>
    <div class="col-md-12">
        <div class="form-group">
        <button class="btn btn-primary btn-block btn-sm" type="submit">SCANNER</button>
        </div>
    </div>
<?php */ ?>

</form>


        <div class="clearfix"></div>
        <div style="text-align: center;">
            <p>&copy; {{ date('Y') }} - Groupe Scolaire Verdin</p>
        </div>


<script type="text/javascript">
$(document).ready(function(){      

        $('#FormID').submit(function(event) {

          event.preventDefault();

          $('#resultajax').append('<div class="splash-container"><img src="{{ url('/') }}/assets/images/loader.gif" alt="En cours ..." /></div>');
          
           $.ajax({
            type: 'POST',
            url: "{{ URL::route('pointage_scan') }}",
            data: $(this).serialize(),
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },

            success: function(data) {


                    if(data == 'no_exist') {

                      $('#resultajax').html("<div class='splash-container'><div class='alert alert-danger center'><strong>Code n'a pas été reconnu</strong></div></div>");
                        $('#barcode').val('');
                        
                    } 

                    else if(data.errormsg) {

                        var image = data.image;
                        var first_name = data.first_name;
                        var last_name = data.last_name;

                        if (image) {
                            var ImgPath = 'images/'+image;
                        } else {
                            var ImgPath = 'images/user.png';
                        }

                        $('#resultajax').html('<div class="splash-container"><div class="card"><div class="card-body"><div class="user-avatar text-center d-block"><img src="{{ url("/") }}/uploads/'+ImgPath+'" class="rounded-circle user-avatar-xxl"></div></div><div class="card-body border-top text-center"><h3 class="font-16 text-uppercase">'+last_name+' '+first_name+'</h3><h3 class="font-16 text-uppercase text-danger">Vous n\'avez pas de cours aujourd\'hui</h3></div></div></div>');

                        setTimeout(function(){ $('#resultajax').html(""); }, 10000);

                        $('#barcode').val('');
                        
                    } 


                    else {

                        var image = data.image;
                        var first_name = data.first_name;
                        var last_name = data.last_name;

                        if (image) {
                            var ImgPath = 'images/'+image;
                        } else {
                            var ImgPath = 'images/user.png';
                        }


                        var d = new Date(); 
                        var t = d.getHours() + ":" + d.getMinutes();

                        $('#resultajax').html('<div class="splash-container"><div class="card"><div class="card-body"><div class="user-avatar text-center d-block"><img src="{{ url("/") }}/uploads/'+ImgPath+'" class="rounded-circle user-avatar-xxl"></div></div><div class="card-body border-top text-center"><h3 class="font-16 text-uppercase">'+last_name+' '+first_name+'</h3><h3 class="font-16 text-uppercase text-success font-weight-bold">Pointage: '+t+'</h3><h3 class="font-16 text-uppercase text-danger">'+data.late+'</h3> </div></div></div>');

                        setTimeout(function(){ $('#resultajax').html(""); }, 5000);

                        $('#barcode').val('');



                  }


              }

            });


                          
          });

          
});

</script>

        </div>

    </div>



    
    
    <script src="{{url('/')}}/assets/vendor/bootstrap/js/bootstrap.bundle.js"></script>
</body>
 
</html>