/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.packaged;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import liquibase.pro.packaged.az;

public class jZ
extends DateFormat {
    protected static final String DATE_FORMAT_STR_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    protected static final String DATE_FORMAT_STR_ISO8601_Z = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    protected static final String DATE_FORMAT_STR_PLAIN = "yyyy-MM-dd";
    protected static final String DATE_FORMAT_STR_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    protected static final String[] ALL_FORMATS = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "EEE, dd MMM yyyy HH:mm:ss zzz", "yyyy-MM-dd"};
    private static final TimeZone DEFAULT_TIMEZONE = TimeZone.getTimeZone("GMT");
    protected static final DateFormat DATE_FORMAT_RFC1123 = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
    protected static final DateFormat DATE_FORMAT_ISO8601;
    protected static final DateFormat DATE_FORMAT_ISO8601_Z;
    protected static final DateFormat DATE_FORMAT_PLAIN;
    public static final jZ instance;
    protected transient TimeZone _timezone;
    protected transient DateFormat _formatRFC1123;
    protected transient DateFormat _formatISO8601;
    protected transient DateFormat _formatISO8601_z;
    protected transient DateFormat _formatPlain;

    public jZ() {
    }

    public jZ(TimeZone timeZone) {
        this._timezone = timeZone;
    }

    public static TimeZone getDefaultTimeZone() {
        return DEFAULT_TIMEZONE;
    }

    public jZ withTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            timeZone = DEFAULT_TIMEZONE;
        }
        return new jZ(timeZone);
    }

    @Override
    public jZ clone() {
        return new jZ();
    }

    public static DateFormat getBlueprintISO8601Format() {
        return DATE_FORMAT_ISO8601;
    }

    public static DateFormat getISO8601Format(TimeZone timeZone) {
        return jZ._cloneFormat(DATE_FORMAT_ISO8601, timeZone);
    }

    public static DateFormat getBlueprintRFC1123Format() {
        return DATE_FORMAT_RFC1123;
    }

    public static DateFormat getRFC1123Format(TimeZone timeZone) {
        return jZ._cloneFormat(DATE_FORMAT_RFC1123, timeZone);
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        if (timeZone != this._timezone) {
            this._formatRFC1123 = null;
            this._formatISO8601 = null;
            this._formatISO8601_z = null;
            this._formatPlain = null;
            this._timezone = timeZone;
        }
    }

    @Override
    public Date parse(String string) {
        ParsePosition parsePosition;
        Comparable<Date> comparable = this.parse(string = string.trim(), parsePosition = new ParsePosition(0));
        if (comparable != null) {
            return comparable;
        }
        comparable = new StringBuilder();
        String[] stringArray = ALL_FORMATS;
        int n2 = ALL_FORMATS.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (((StringBuilder)comparable).length() > 0) {
                ((StringBuilder)comparable).append("\", \"");
            } else {
                ((StringBuilder)comparable).append('\"');
            }
            ((StringBuilder)comparable).append(string2);
        }
        ((StringBuilder)comparable).append('\"');
        throw new ParseException(String.format("Can not parse date \"%s\": not compatible with any of standard forms (%s)", string, ((StringBuilder)comparable).toString()), parsePosition.getErrorIndex());
    }

    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        char c2;
        if (this.looksLikeISO8601(string)) {
            return this.parseAsISO8601(string, parsePosition);
        }
        int n2 = string.length();
        while (--n2 >= 0 && ((c2 = string.charAt(n2)) >= '0' && c2 <= '9' || n2 <= 0 && c2 == '-')) {
        }
        if (n2 < 0 && az.inLongRange(string, false)) {
            return new Date(Long.parseLong(string));
        }
        return this.parseAsRFC1123(string, parsePosition);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (this._formatISO8601 == null) {
            this._formatISO8601 = this._cloneFormat(DATE_FORMAT_ISO8601);
        }
        return this._formatISO8601.format(date, stringBuffer, fieldPosition);
    }

    protected boolean looksLikeISO8601(String string) {
        return string.length() >= 5 && Character.isDigit(string.charAt(0)) && Character.isDigit(string.charAt(3)) && string.charAt(4) == '-';
    }

    protected Date parseAsISO8601(String string, ParsePosition parsePosition) {
        DateFormat dateFormat;
        int n2 = string.length();
        char c2 = string.charAt(n2 - 1);
        if (n2 <= 10 && Character.isDigit(c2)) {
            dateFormat = this._formatPlain;
            if (dateFormat == null) {
                dateFormat = this._formatPlain = this._cloneFormat(DATE_FORMAT_PLAIN);
            }
        } else if (c2 == 'Z') {
            dateFormat = this._formatISO8601_z;
            if (dateFormat == null) {
                dateFormat = this._formatISO8601_z = this._cloneFormat(DATE_FORMAT_ISO8601_Z);
            }
            if (string.charAt(n2 - 4) == ':') {
                StringBuilder stringBuilder = new StringBuilder(string);
                stringBuilder.insert(n2 - 1, ".000");
                string = stringBuilder.toString();
            }
        } else if (jZ.hasTimeZone(string)) {
            StringBuilder stringBuilder;
            c2 = string.charAt(n2 - 3);
            if (c2 == ':') {
                stringBuilder = new StringBuilder(string);
                stringBuilder.delete(n2 - 3, n2 - 2);
                string = stringBuilder.toString();
            } else if (c2 == '+' || c2 == '-') {
                string = string + "00";
            }
            n2 = string.length();
            if (Character.isDigit(string.charAt(n2 - 9))) {
                stringBuilder = new StringBuilder(string);
                stringBuilder.insert(n2 - 5, ".000");
                string = stringBuilder.toString();
            }
            dateFormat = this._formatISO8601;
            if (this._formatISO8601 == null) {
                dateFormat = this._formatISO8601 = this._cloneFormat(DATE_FORMAT_ISO8601);
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder(string);
            if (n2 - string.lastIndexOf(84) - 1 <= 8) {
                stringBuilder.append(".000");
            }
            stringBuilder.append('Z');
            string = stringBuilder.toString();
            dateFormat = this._formatISO8601_z;
            if (dateFormat == null) {
                dateFormat = this._formatISO8601_z = this._cloneFormat(DATE_FORMAT_ISO8601_Z);
            }
        }
        return dateFormat.parse(string, parsePosition);
    }

    protected Date parseAsRFC1123(String string, ParsePosition parsePosition) {
        if (this._formatRFC1123 == null) {
            this._formatRFC1123 = this._cloneFormat(DATE_FORMAT_RFC1123);
        }
        return this._formatRFC1123.parse(string, parsePosition);
    }

    private static final boolean hasTimeZone(String string) {
        int n2 = string.length();
        if (n2 >= 6) {
            char c2 = string.charAt(n2 - 6);
            if (c2 == '+' || c2 == '-') {
                return true;
            }
            c2 = string.charAt(n2 - 5);
            if (c2 == '+' || c2 == '-') {
                return true;
            }
            c2 = string.charAt(n2 - 3);
            if (c2 == '+' || c2 == '-') {
                return true;
            }
        }
        return false;
    }

    private final DateFormat _cloneFormat(DateFormat dateFormat) {
        return jZ._cloneFormat(dateFormat, this._timezone);
    }

    private static final DateFormat _cloneFormat(DateFormat dateFormat, TimeZone timeZone) {
        dateFormat = (DateFormat)dateFormat.clone();
        if (timeZone != null) {
            dateFormat.setTimeZone(timeZone);
        }
        return dateFormat;
    }

    static {
        DATE_FORMAT_RFC1123.setTimeZone(DEFAULT_TIMEZONE);
        DATE_FORMAT_ISO8601 = new SimpleDateFormat(DATE_FORMAT_STR_ISO8601);
        DATE_FORMAT_ISO8601.setTimeZone(DEFAULT_TIMEZONE);
        DATE_FORMAT_ISO8601_Z = new SimpleDateFormat(DATE_FORMAT_STR_ISO8601_Z);
        DATE_FORMAT_ISO8601_Z.setTimeZone(DEFAULT_TIMEZONE);
        DATE_FORMAT_PLAIN = new SimpleDateFormat(DATE_FORMAT_STR_PLAIN);
        DATE_FORMAT_PLAIN.setTimeZone(DEFAULT_TIMEZONE);
        instance = new jZ();
    }
}

