/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.channel.ChannelHandler;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BaseDataHandler;
import org.traccar.Context;
import org.traccar.Main;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.database.IdentityManager;
import org.traccar.helper.Checksum;
import org.traccar.model.Device;
import org.traccar.model.Group;
import org.traccar.model.Position;

@ChannelHandler.Sharable
public class WebDataHandler
extends BaseDataHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDataHandler.class);
    private static final String KEY_POSITION = "position";
    private static final String KEY_DEVICE = "device";
    private final IdentityManager identityManager;
    private final ObjectMapper objectMapper;
    private final Client client;
    private final String url;
    private final String header;
    private final boolean json;
    private final boolean urlVariables;
    private final boolean retryEnabled;
    private final int retryDelay;
    private final int retryCount;
    private final int retryLimit;
    private final AtomicInteger deliveryPending;

    @Inject
    public WebDataHandler(Config config, IdentityManager identityManager, ObjectMapper objectMapper, Client client) {
        this.identityManager = identityManager;
        this.objectMapper = objectMapper;
        this.client = client;
        this.url = config.getString(Keys.FORWARD_URL);
        this.header = config.getString(Keys.FORWARD_HEADER);
        this.json = config.getBoolean(Keys.FORWARD_JSON);
        this.urlVariables = config.getBoolean(Keys.FORWARD_URL_VARIABLES);
        this.retryEnabled = config.getBoolean(Keys.FORWARD_RETRY_ENABLE);
        this.retryDelay = config.getInteger(Keys.FORWARD_RETRY_DELAY, 100);
        this.retryCount = config.getInteger(Keys.FORWARD_RETRY_COUNT, 10);
        this.retryLimit = config.getInteger(Keys.FORWARD_RETRY_LIMIT, 100);
        this.deliveryPending = new AtomicInteger(0);
    }

    private static String formatSentence(Position position) {
        StringBuilder s = new StringBuilder("$GPRMC,");
        try (Formatter f = new Formatter(s, Locale.ENGLISH);){
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
            calendar.setTimeInMillis(position.getFixTime().getTime());
            f.format("%1$tH%1$tM%1$tS.%1$tL,A,", calendar);
            double lat = position.getLatitude();
            double lon = position.getLongitude();
            f.format("%02d%07.4f,%c,", (int)Math.abs(lat), Math.abs(lat) % 1.0 * 60.0, Character.valueOf(lat < 0.0 ? (char)'S' : 'N'));
            f.format("%03d%07.4f,%c,", (int)Math.abs(lon), Math.abs(lon) % 1.0 * 60.0, Character.valueOf(lon < 0.0 ? (char)'W' : 'E'));
            f.format("%.2f,%.2f,", position.getSpeed(), position.getCourse());
            f.format("%1$td%1$tm%1$ty,,", calendar);
        }
        s.append(Checksum.nmea(s.substring(1)));
        return s.toString();
    }

    private String calculateStatus(Position position) {
        if (position.getAttributes().containsKey("alarm")) {
            return "0xF841";
        }
        if (position.getSpeed() < 1.0) {
            return "0xF020";
        }
        return "0xF11C";
    }

    public String formatRequest(Position position) throws UnsupportedEncodingException, JsonProcessingException {
        Device device = this.identityManager.getById(position.getDeviceId());
        String request = this.url.replace("{name}", URLEncoder.encode(device.getName(), StandardCharsets.UTF_8.name())).replace("{uniqueId}", device.getUniqueId()).replace("{status}", device.getStatus()).replace("{deviceId}", String.valueOf(position.getDeviceId())).replace("{protocol}", String.valueOf(position.getProtocol())).replace("{deviceTime}", String.valueOf(position.getDeviceTime().getTime())).replace("{fixTime}", String.valueOf(position.getFixTime().getTime())).replace("{valid}", String.valueOf(position.getValid())).replace("{latitude}", String.valueOf(position.getLatitude())).replace("{longitude}", String.valueOf(position.getLongitude())).replace("{altitude}", String.valueOf(position.getAltitude())).replace("{speed}", String.valueOf(position.getSpeed())).replace("{course}", String.valueOf(position.getCourse())).replace("{accuracy}", String.valueOf(position.getAccuracy())).replace("{statusCode}", this.calculateStatus(position));
        if (position.getAddress() != null) {
            request = request.replace("{address}", URLEncoder.encode(position.getAddress(), StandardCharsets.UTF_8.name()));
        }
        if (request.contains("{attributes}")) {
            String attributes = this.objectMapper.writeValueAsString(position.getAttributes());
            request = request.replace("{attributes}", URLEncoder.encode(attributes, StandardCharsets.UTF_8.name()));
        }
        if (request.contains("{gprmc}")) {
            request = request.replace("{gprmc}", WebDataHandler.formatSentence(position));
        }
        if (request.contains("{group}")) {
            Group group;
            String deviceGroupName = "";
            if (device.getGroupId() != 0L && (group = (Group)Context.getGroupsManager().getById(device.getGroupId())) != null) {
                deviceGroupName = group.getName();
            }
            request = request.replace("{group}", URLEncoder.encode(deviceGroupName, StandardCharsets.UTF_8.name()));
        }
        return request;
    }

    @Override
    protected Position handlePosition(Position position) {
        AsyncRequestAndCallback request = new AsyncRequestAndCallback(position);
        request.send();
        return position;
    }

    private Map<String, Object> prepareJsonPayload(Position position) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        Device device = this.identityManager.getById(position.getDeviceId());
        data.put(KEY_POSITION, position);
        if (device != null) {
            data.put(KEY_DEVICE, device);
        }
        return data;
    }

    class AsyncRequestAndCallback
    implements InvocationCallback<Response>,
    TimerTask {
        private int retries = 0;
        private Map<String, Object> payload;
        private final Invocation.Builder requestBuilder;
        private MediaType mediaType = MediaType.APPLICATION_JSON_TYPE;

        AsyncRequestAndCallback(Position position) {
            String formattedUrl;
            try {
                formattedUrl = WebDataHandler.this.json && !WebDataHandler.this.urlVariables ? WebDataHandler.this.url : WebDataHandler.this.formatRequest(position);
            }
            catch (JsonProcessingException | UnsupportedEncodingException e) {
                throw new RuntimeException("Forwarding formatting error", e);
            }
            this.requestBuilder = WebDataHandler.this.client.target(formattedUrl).request();
            if (WebDataHandler.this.header != null && !WebDataHandler.this.header.isEmpty()) {
                for (String line : WebDataHandler.this.header.split("\\r?\\n")) {
                    String[] values = line.split(":", 2);
                    String headerName = values[0].trim();
                    String headerValue = values[1].trim();
                    if (headerName.equals("Content-Type")) {
                        this.mediaType = MediaType.valueOf((String)headerValue);
                        continue;
                    }
                    this.requestBuilder.header(headerName, (Object)headerValue);
                }
            }
            if (WebDataHandler.this.json) {
                this.payload = WebDataHandler.this.prepareJsonPayload(position);
            }
            WebDataHandler.this.deliveryPending.incrementAndGet();
        }

        private void send() {
            LOGGER.debug("Position forwarding initiated");
            if (WebDataHandler.this.json) {
                try {
                    Entity entity = Entity.entity((Object)WebDataHandler.this.objectMapper.writeValueAsString(this.payload), (MediaType)this.mediaType);
                    this.requestBuilder.async().post(entity, (InvocationCallback)this);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException("Failed to serialize location to json", e);
                }
            } else {
                this.requestBuilder.async().get((InvocationCallback)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void retry(Throwable throwable) {
            int pending;
            boolean scheduled = false;
            try {
                if (WebDataHandler.this.retryEnabled && WebDataHandler.this.deliveryPending.get() <= WebDataHandler.this.retryLimit && this.retries < WebDataHandler.this.retryCount) {
                    this.schedule();
                    scheduled = true;
                }
                pending = scheduled ? WebDataHandler.this.deliveryPending.get() : WebDataHandler.this.deliveryPending.decrementAndGet();
            }
            catch (Throwable throwable2) {
                int pending2 = scheduled ? WebDataHandler.this.deliveryPending.get() : WebDataHandler.this.deliveryPending.decrementAndGet();
                LOGGER.warn("Position forwarding failed: " + pending2 + " pending", throwable);
                throw throwable2;
            }
            LOGGER.warn("Position forwarding failed: " + pending + " pending", throwable);
        }

        private void schedule() {
            ((Timer)Main.getInjector().getInstance(Timer.class)).newTimeout((TimerTask)this, (long)WebDataHandler.this.retryDelay * (long)Math.pow(2.0, this.retries++), TimeUnit.MILLISECONDS);
        }

        public void completed(Response response) {
            if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                WebDataHandler.this.deliveryPending.decrementAndGet();
                LOGGER.debug("Position forwarding succeeded");
            } else {
                this.retry(new RuntimeException("Status code 2xx expected"));
            }
        }

        public void failed(Throwable throwable) {
            this.retry(throwable);
        }

        public void run(Timeout timeout) {
            boolean sent = false;
            try {
                if (!timeout.isCancelled()) {
                    this.send();
                    sent = true;
                }
            }
            finally {
                if (!sent) {
                    WebDataHandler.this.deliveryPending.decrementAndGet();
                }
            }
        }
    }
}

