/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.protocol.ArnaviBinaryProtocolDecoder;
import org.traccar.protocol.ArnaviTextProtocolDecoder;

public class ArnaviProtocolDecoder
extends BaseProtocolDecoder {
    private final ArnaviTextProtocolDecoder textProtocolDecoder;
    private final ArnaviBinaryProtocolDecoder binaryProtocolDecoder;

    public ArnaviProtocolDecoder(Protocol protocol) {
        super(protocol);
        this.textProtocolDecoder = new ArnaviTextProtocolDecoder(protocol);
        this.binaryProtocolDecoder = new ArnaviBinaryProtocolDecoder(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (buf.getByte(buf.readerIndex()) == 36) {
            return this.textProtocolDecoder.decode(channel, remoteAddress, msg);
        }
        return this.binaryProtocolDecoder.decode(channel, remoteAddress, msg);
    }
}

