/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Context;
import org.traccar.DeviceSession;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.Position;

public class MeiligaoProtocolDecoder
extends BaseProtocolDecoder {
    private Map<Byte, ByteBuf> photos = new HashMap<Byte, ByteBuf>();
    private static final Pattern PATTERN = new PatternBuilder().number("(d+)(dd)(dd).?d*,").expression("([AV]),").number("(d+)(dd.d+),").expression("([NS]),").number("(d+)(dd.d+),").expression("([EW]),").number("(d+.?d*)?,").number("(d+.?d*)?,").number("(dd)(dd)(dd)").expression("[^\\|]*").groupBegin().number("|(d+.d+)?").number("|(-?d+.?d*)?").number("|(xxxx)?").groupBegin().number("|(xxxx),(xxxx)").number(",(xxxx)").optional().number(",(xxxx)").optional().number(",(xxxx)").optional().number(",(xxxx)").optional().number(",(xxxx)").optional().number(",(xxxx)").optional().groupBegin().number("|x{16,20}").number("|(xx)").number("|(x{8})").groupBegin().number("|(xx)").groupBegin().text("|").expression("(.*)").groupEnd("?").groupEnd("?").or().number("|(d{1,9})").groupBegin().number("|(x{5,})").groupEnd("?").groupEnd("?").groupEnd("?").groupEnd("?").any().compile();
    private static final Pattern PATTERN_RFID = new PatternBuilder().number("|(dd)(dd)(dd),").number("(dd)(dd)(dd),").number("(d+)(dd.d+),").expression("([NS]),").number("(d+)(dd.d+),").expression("([EW])").compile();
    private static final Pattern PATTERN_OBD = new PatternBuilder().number("(d+.d+),").number("(d+),").number("(d+),").number("(d+.d+),").number("(d+.d+),").number("(-?d+),").number("(d+.d+),").number("(d+.d+),").number("(d+.d+),").number("(d+.?d*),").number("(d+.d+),").number("(d+.d+),").number("(d+),").number("(d+),").number("(d+)").compile();
    private static final Pattern PATTERN_OBDA = new PatternBuilder().number("(d+),").number("(d+.d+),").number("(d+.d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+),").number("(d+)").compile();
    public static final int MSG_HEARTBEAT = 1;
    public static final int MSG_SERVER = 2;
    public static final int MSG_LOGIN = 20480;
    public static final int MSG_LOGIN_RESPONSE = 16384;
    public static final int MSG_POSITION = 39253;
    public static final int MSG_POSITION_LOGGED = 36886;
    public static final int MSG_ALARM = 39321;
    public static final int MSG_RFID = 39270;
    public static final int MSG_RETRANSMISSION = 26248;
    public static final int MSG_OBD_RT = 39169;
    public static final int MSG_OBD_RTA = 39170;
    public static final int MSG_TRACK_ON_DEMAND = 16641;
    public static final int MSG_TRACK_BY_INTERVAL = 16642;
    public static final int MSG_MOVEMENT_ALARM = 16646;
    public static final int MSG_OUTPUT_CONTROL_1 = 16660;
    public static final int MSG_OUTPUT_CONTROL_2 = 16661;
    public static final int MSG_TIME_ZONE = 16690;
    public static final int MSG_TAKE_PHOTO = 16721;
    public static final int MSG_UPLOAD_PHOTO = 2048;
    public static final int MSG_UPLOAD_PHOTO_RESPONSE = 34817;
    public static final int MSG_DATA_PHOTO = 39304;
    public static final int MSG_POSITION_IMAGE = 39287;
    public static final int MSG_UPLOAD_COMPLETE = 3968;
    public static final int MSG_REBOOT_GPS = 18690;

    public MeiligaoProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private DeviceSession identify(ByteBuf buf, Channel channel, SocketAddress remoteAddress) {
        String id;
        short b;
        int d1;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 7 && (d1 = ((b = buf.readUnsignedByte()) & 0xF0) >> 4) != 15; ++i) {
            builder.append(d1);
            int d2 = b & 0xF;
            if (d2 == 15) break;
            builder.append(d2);
        }
        if ((id = builder.toString()).length() == 14) {
            return this.getDeviceSession(channel, remoteAddress, id, id + Checksum.luhn(Long.parseLong(id)));
        }
        return this.getDeviceSession(channel, remoteAddress, id);
    }

    private static void sendResponse(Channel channel, SocketAddress remoteAddress, ByteBuf id, int type, ByteBuf msg) {
        if (channel != null) {
            ByteBuf buf = Unpooled.buffer((int)(4 + id.readableBytes() + 2 + msg.readableBytes() + 2 + 2));
            buf.writeByte(64);
            buf.writeByte(64);
            buf.writeShort(buf.capacity());
            buf.writeBytes(id);
            buf.writeShort(type);
            buf.writeBytes(msg);
            msg.release();
            buf.writeShort(Checksum.crc16(Checksum.CRC16_CCITT_FALSE, buf.nioBuffer()));
            buf.writeByte(13);
            buf.writeByte(10);
            channel.writeAndFlush((Object)new NetworkMessage(buf, remoteAddress));
        }
    }

    private String decodeAlarm(short value) {
        switch (value) {
            case 1: {
                return "sos";
            }
            case 16: {
                return "lowBattery";
            }
            case 17: {
                return "overspeed";
            }
            case 18: {
                return "movement";
            }
            case 19: {
                return "geofenceEnter";
            }
            case 20: {
                return "accident";
            }
            case 80: {
                return "powerOff";
            }
            case 83: {
                return "gpsAntennaCut";
            }
            case 114: {
                return "hardBraking";
            }
            case 115: {
                return "hardAcceleration";
            }
        }
        return null;
    }

    private Position decodeRegular(Position position, String sentence) {
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        DateBuilder dateBuilder = new DateBuilder().setTime(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        if (parser.hasNext()) {
            position.setSpeed(parser.nextDouble(0.0));
        }
        if (parser.hasNext()) {
            position.setCourse(parser.nextDouble(0.0));
        }
        dateBuilder.setDateReverse(parser.nextInt(0), parser.nextInt(0), parser.nextInt(0));
        position.setTime(dateBuilder.getDate());
        position.set("hdop", parser.nextDouble());
        if (parser.hasNext()) {
            position.setAltitude(parser.nextDouble(0.0));
        }
        if (parser.hasNext()) {
            int i;
            int status = parser.nextHexInt();
            for (i = 1; i <= 5; ++i) {
                position.set("out" + i, BitUtil.check(status, i - 1));
            }
            for (i = 1; i <= 5; ++i) {
                position.set("in" + i, BitUtil.check(status, i - 1 + 8));
            }
        }
        for (int i = 1; i <= 8; ++i) {
            position.set("adc" + i, parser.nextHexInt());
        }
        position.set("rssi", parser.nextHexInt());
        position.set("odometer", parser.nextHexLong());
        position.set("sat", parser.nextHexInt());
        position.set("driverLicense", parser.next());
        position.set("odometer", parser.nextLong());
        position.set("driverUniqueId", parser.next());
        return position;
    }

    private Position decodeRfid(Position position, String sentence) {
        Parser parser = new Parser(PATTERN_RFID, sentence);
        if (!parser.matches()) {
            return null;
        }
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.HMS_DMY));
        position.setValid(true);
        position.setLatitude(parser.nextCoordinate());
        position.setLongitude(parser.nextCoordinate());
        return position;
    }

    private Position decodeObd(Position position, String sentence) {
        Parser parser = new Parser(PATTERN_OBD, sentence);
        if (!parser.matches()) {
            return null;
        }
        this.getLastLocation(position, null);
        position.set("battery", parser.nextDouble());
        position.set("rpm", parser.nextInt());
        position.set("obdSpeed", parser.nextInt());
        position.set("throttle", parser.nextDouble());
        position.set("engineLoad", parser.nextDouble());
        position.set("coolantTemp", parser.nextInt());
        position.set("fuelConsumption", parser.nextDouble());
        position.set("averageFuelConsumption", parser.nextDouble());
        position.set("drivingRange", parser.nextDouble());
        position.set("odometer", parser.nextDouble());
        position.set("singleFuelConsumption", parser.nextDouble());
        position.set("fuelUsed", parser.nextDouble());
        position.set("dtcs", parser.nextInt());
        position.set("hardAccelerationCount", parser.nextInt());
        position.set("hardBrakingCount", parser.nextInt());
        return position;
    }

    private Position decodeObdA(Position position, String sentence) {
        Parser parser = new Parser(PATTERN_OBDA, sentence);
        if (!parser.matches()) {
            return null;
        }
        this.getLastLocation(position, null);
        position.set("totalIgnitionNo", parser.nextInt(0));
        position.set("totalDrivingTime", parser.nextDouble(0.0));
        position.set("totalIdlingTime", parser.nextDouble(0.0));
        position.set("averageHotStartTime", parser.nextInt(0));
        position.set("averageSpeed", parser.nextInt(0));
        position.set("historyHighestSpeed", parser.nextInt(0));
        position.set("historyHighestRpm", parser.nextInt(0));
        position.set("totalHarshAccerleration", parser.nextInt(0));
        position.set("totalHarshBrake", parser.nextInt(0));
        return position;
    }

    private List<Position> decodeRetransmission(ByteBuf buf, DeviceSession deviceSession) {
        LinkedList<Position> positions = new LinkedList<Position>();
        int count = buf.readUnsignedByte();
        for (int i = 0; i < count; ++i) {
            buf.readUnsignedByte();
            int endIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)92);
            if (endIndex < 0) {
                endIndex = buf.writerIndex() - 4;
            }
            String sentence = buf.readSlice(endIndex - buf.readerIndex()).toString(StandardCharsets.US_ASCII);
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position = this.decodeRegular(position, sentence);
            if (position != null) {
                positions.add(position);
            }
            if (buf.readableBytes() <= 4) continue;
            buf.readUnsignedByte();
        }
        return positions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        buf.readShort();
        ByteBuf id = buf.readSlice(7);
        int command = buf.readUnsignedShort();
        if (command == 20480) {
            ByteBuf response = Unpooled.wrappedBuffer((byte[])new byte[]{1});
            MeiligaoProtocolDecoder.sendResponse(channel, remoteAddress, id, 16384, response);
            return null;
        }
        if (command == 1) {
            ByteBuf response = Unpooled.wrappedBuffer((byte[])new byte[]{1});
            MeiligaoProtocolDecoder.sendResponse(channel, remoteAddress, id, 1, response);
            return null;
        }
        if (command == 2) {
            ByteBuf response = Unpooled.copiedBuffer((CharSequence)this.getServer(channel, ':'), (Charset)StandardCharsets.US_ASCII);
            MeiligaoProtocolDecoder.sendResponse(channel, remoteAddress, id, 2, response);
            return null;
        }
        if (command == 2048) {
            byte imageIndex = buf.readByte();
            this.photos.put(imageIndex, Unpooled.buffer());
            ByteBuf response = Unpooled.copiedBuffer((byte[])new byte[]{imageIndex});
            MeiligaoProtocolDecoder.sendResponse(channel, remoteAddress, id, 34817, response);
            return null;
        }
        if (command == 3968) {
            byte imageIndex = buf.readByte();
            ByteBuf response = Unpooled.copiedBuffer((byte[])new byte[]{imageIndex, 0, 0});
            MeiligaoProtocolDecoder.sendResponse(channel, remoteAddress, id, 26248, response);
            return null;
        }
        DeviceSession deviceSession = this.identify(id, channel, remoteAddress);
        if (deviceSession == null) {
            return null;
        }
        if (command == 39304) {
            byte imageIndex = buf.readByte();
            buf.readUnsignedShort();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            this.photos.get(imageIndex).writeBytes(buf, buf.readableBytes() - 2 - 2);
            return null;
        }
        if (command == 26248) {
            return this.decodeRetransmission(buf, deviceSession);
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        if (command == 39321) {
            short alarmCode = buf.readUnsignedByte();
            position.set("alarm", this.decodeAlarm(alarmCode));
            if (alarmCode >= 2 && alarmCode <= 5) {
                position.set("in" + alarmCode, 1);
            } else if (alarmCode >= 50 && alarmCode <= 53) {
                position.set("in" + (alarmCode - 48), 0);
            }
        } else if (command == 36886) {
            buf.skipBytes(6);
        } else if (command == 39270) {
            for (int i = 0; i < 15; ++i) {
                long rfid = buf.readUnsignedInt();
                if (rfid == 0L) continue;
                String card = String.format("%010d", rfid);
                position.set("card" + (i + 1), card);
                position.set("driverUniqueId", card);
            }
        } else if (command == 39287) {
            byte imageIndex = buf.readByte();
            buf.readUnsignedByte();
            String uniqueId = Context.getIdentityManager().getById(deviceSession.getDeviceId()).getUniqueId();
            ByteBuf photo = this.photos.remove(imageIndex);
            try {
                position.set("image", Context.getMediaManager().writeFile(uniqueId, photo, "jpg"));
            }
            finally {
                photo.release();
            }
        }
        String sentence = buf.toString(buf.readerIndex(), buf.readableBytes() - 4, StandardCharsets.US_ASCII);
        switch (command) {
            case 36886: 
            case 39253: 
            case 39287: 
            case 39321: {
                return this.decodeRegular(position, sentence);
            }
            case 39270: {
                return this.decodeRfid(position, sentence);
            }
            case 39169: {
                return this.decodeObd(position, sentence);
            }
            case 39170: {
                return this.decodeObdA(position, sentence);
            }
        }
        return null;
    }
}

